//===========================================================================
// InformStyleDlg.cpp : implementation of the CInformStyleDlg class
//===========================================================================

#include "stdafx.h"
#include "InformStyleDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


//***************************************************************************
// CInformStyleDlg basics
//***************************************************************************

/////////////////////////////////////////////////////////////////////////////
// Static Data
//
CString	CInformStyleDlg::s_LastRecord;


/////////////////////////////////////////////////////////////////////////////
// Construction
//
// The caller uses this to specify which set of style records are to be 
// edited.
//
CInformStyleDlg::CInformStyleDlg(InformStyleRecordSet& master, 
								 CWnd* pParent /*=NULL*/) :
	CDialog(CInformStyleDlg::IDD, pParent),
	m_MasterStyles(master)
{
	//{{AFX_DATA_INIT(CInformStyleDlg)
	m_Bold = FALSE;
	m_Italic = FALSE;
	m_TypeName = _T("");
	//}}AFX_DATA_INIT
	m_TypeIndex = -1;
	m_CurrentStyles = m_MasterStyles;
}


/////////////////////////////////////////////////////////////////////////////
// DoDataExchange()
//
void CInformStyleDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CInformStyleDlg)
	DDX_Control(pDX, IDC_SAMPLE_RICHEDIT, m_SampleText);
	DDX_Control(pDX, IDC_TYPE_LIST, m_TypeList);
	DDX_Check(pDX, IDC_BOLD_CHECK, m_Bold);
	DDX_Check(pDX, IDC_ITALIC_CHECK, m_Italic);
	DDX_LBString(pDX, IDC_TYPE_LIST, m_TypeName);
	//}}AFX_DATA_MAP
}


/////////////////////////////////////////////////////////////////////////////
// Message Map
//
BEGIN_MESSAGE_MAP(CInformStyleDlg, CDialog)
	//{{AFX_MSG_MAP(CInformStyleDlg)
	ON_BN_CLICKED(IDC_COLOUR_BUTTON, OnChangeColour)
	ON_LBN_SELCHANGE(IDC_TYPE_LIST, OnSelchangeType)
	ON_BN_CLICKED(IDC_ITALIC_CHECK, OnStyleChange)
	ON_BN_CLICKED(IDC_BOLD_CHECK, OnStyleChange)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


//***************************************************************************
// CInformStyleDlg helpers
//***************************************************************************

/////////////////////////////////////////////////////////////////////////////
// SetDlgFromRecord()
//
// Copy colour, bold & italic states from the current record to the dialog.
//
void CInformStyleDlg::SetDlgFromRecord()
{
	InformStyleRecord * record;
	m_StyleMap.Lookup(m_TypeName, record);
	if ( record )
	{
		m_Colour = record->Colour();
		m_Bold = record->Bold();
		m_Italic = record->Italic();
		UpdateSample();
	}
	UpdateData(FALSE);
}


/////////////////////////////////////////////////////////////////////////////
// SetRecordFromDlg()
//
// Copy colour, bold & italic states from the dialog to the current record.
//
void CInformStyleDlg::SetRecordFromDlg()
{
	InformStyleRecord * record;
	m_StyleMap.Lookup(m_TypeName, record);
	if ( record )
	{
		record->Colour(m_Colour);
		record->Bold(m_Bold);
		record->Italic(m_Italic);
		UpdateSample();
	}
}


/////////////////////////////////////////////////////////////////////////////
// UpdateSample()
//
// Make the appearance of the sample box match the current dialog state.
//
void CInformStyleDlg::UpdateSample()
{
	CHARFORMAT cf;
	cf.cbSize = sizeof(CHARFORMAT);
	cf.dwMask = CFM_BOLD | CFM_COLOR | CFM_ITALIC;
	cf.dwEffects = ( m_Bold ? CFE_BOLD : 0 ) | ( m_Italic ? CFE_ITALIC : 0 );
	cf.crTextColor = m_Colour;

	m_SampleText.SetSel(0, -1);
	m_SampleText.SetSelectionCharFormat(cf);
	m_SampleText.SetSel(0, 0);
}


//***************************************************************************
// CInformStyleDlg message handlers
//***************************************************************************

/////////////////////////////////////////////////////////////////////////////
// OnCancel()
//
// Update the last-viewed record name.
//
void CInformStyleDlg::OnCancel()
{
	UpdateData(TRUE);
	m_TypeList.GetText(m_TypeList.GetCurSel(), s_LastRecord);
	CDialog::OnCancel();
}


/////////////////////////////////////////////////////////////////////////////
// OnChangeColour()
//
// The user wants to change the colour of the current record.
//
void CInformStyleDlg::OnChangeColour()
{
	UpdateData(TRUE);
	CColorDialog dlgColor(m_Colour);
	if (dlgColor.DoModal() == IDOK)
	{
		m_Colour = dlgColor.GetColor();
		UpdateSample();
	}
}


/////////////////////////////////////////////////////////////////////////////
// OnInitDialog()
//
// Set up various things, including a copy of the master record set, the 
// list of styles, and a map to get quickly from the listbox name to the 
// record.  Use a static member to set the initial record to the same one as
// last time, if possible.
//
BOOL CInformStyleDlg::OnInitDialog()
{
	CDialog::OnInitDialog();
	
	m_SampleText.SetWindowText(_T(" Sample"));

	m_StyleMap.RemoveAll();
	m_TypeList.ResetContent();
	POSITION pos = m_CurrentStyles.GetStartPosition();
	InformStyle key = InvalidStyle;
	InformStyleRecord * entry;
	while ( NULL != pos )
	{
		m_CurrentStyles.GetNextAssoc(pos, key, entry);
		ASSERT(entry);
		m_StyleMap[entry->Name()] = entry;
		m_TypeList.AddString(entry->Name());
	}

	if ( s_LastRecord.IsEmpty() || 
		 LB_ERR == m_TypeList.SelectString(-1, s_LastRecord) )
		m_TypeList.SetCurSel(0);
	
	m_TypeIndex = m_TypeList.GetCurSel();
	m_TypeList.GetText(m_TypeIndex, m_TypeName);
	SetDlgFromRecord();

	return TRUE;
}


/////////////////////////////////////////////////////////////////////////////
// OnOK()
//
// Update the last-viewed record name, then checks whether or not anything 
// has changed.  If it has, copy the changes to the master record set; 
// otherwise behaves as if the user hit cancel (so the caller knows not to 
// bother updating anything).
//
void CInformStyleDlg::OnOK()
{
	UpdateData(TRUE);
	SetRecordFromDlg();
	m_TypeList.GetText(m_TypeList.GetCurSel(), s_LastRecord);
	if ( m_CurrentStyles != m_MasterStyles )
	{
		m_MasterStyles = m_CurrentStyles;
		CDialog::OnOK();
	}
	else
		CDialog::OnCancel();	// Haven't actually changed anything...
}


/////////////////////////////////////////////////////////////////////////////
// OnSelchangeType()
//
// The user wants to change which record is current.
//
void CInformStyleDlg::OnSelchangeType()
{
	SetRecordFromDlg();
	UpdateData(TRUE);
	m_TypeIndex = m_TypeList.GetCurSel();
	SetDlgFromRecord();
}


/////////////////////////////////////////////////////////////////////////////
// OnStyleChange()
//
// The user wants to change the bold or italic style of the current record.
//
void CInformStyleDlg::OnStyleChange()
{
	UpdateData(TRUE);
	UpdateSample();
}


