//===========================================================================
// InformStyleDlg.h : interface of the CInformStyleDlg class
//
// This is a reasonably self-explanatory classwizard-generated dialog, 
// through which the user can change the colours and bold/italic states used 
// to represent the styles on-screen.
//
// Note that the dialog resources are in the sample application and will 
// need to be copied if you want to use this.
//
// The main difference between standard MFC dialogs and this one is that I 
// make it the responsibility of the dialog to look after it's own data, 
// rather than the calling function - see the OnOK() method for further 
// details.
//===========================================================================

#if !defined(INFORMSTYLEDLG_H)
#define INFORMSTYLEDLG_H

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000


//***************************************************************************
// Includes
//***************************************************************************

#include "resource.h"
#include "InformStyleRecord.h"


//***************************************************************************
// Definitions
//***************************************************************************

/////////////////////////////////////////////////////////////////////////////
// CInformStyleDlg Definition
//
class CInformStyleDlg : public CDialog
{
// Construction
  public:
	CInformStyleDlg(InformStyleRecordSet& master, CWnd* pParent=NULL);

// Dialog Data
  protected:
	//{{AFX_DATA(CInformStyleDlg)
	enum { IDD = IDD_STYLE_DIALOG };
	CRichEditCtrl	m_SampleText;
	CListBox	m_TypeList;
	BOOL		m_Bold;
	BOOL		m_Italic;
	CString	m_TypeName;
	//}}AFX_DATA
	int			m_TypeIndex;
	COLORREF	m_Colour;
	InformStyleRecordSet	m_CurrentStyles;
	InformStyleRecordSet&	m_MasterStyles;
	CTypedPtrMap<CMapStringToPtr,CString,InformStyleRecord*>	m_StyleMap;

	static CString	s_LastRecord;

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CInformStyleDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
  protected:
	// Generated message map functions
	//{{AFX_MSG(CInformStyleDlg)
	afx_msg void OnChangeColour();
	virtual BOOL OnInitDialog();
	virtual void OnOK();
	afx_msg void OnSelchangeType();
	afx_msg void OnStyleChange();
	virtual void OnCancel();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

	void	SetRecordFromDlg();
	void	SetDlgFromRecord();
	void	UpdateSample();
};

//{{AFX_INSERT_LOCATION}}

#endif // !defined(INFORMSTYLEDLG_H)
