//===========================================================================
// InformViewerDoc.cpp : implementation of the CInformViewerDoc class
//===========================================================================

#include "stdafx.h"
#include "InformViewer.h"
#include "InformViewerDoc.h"
#include <fstream.h>

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


//***************************************************************************
// CInformViewerDoc basics
//***************************************************************************

/////////////////////////////////////////////////////////////////////////////
// Construction
//
IMPLEMENT_DYNCREATE(CInformViewerDoc, CDocument)

CInformViewerDoc::CInformViewerDoc()
{
}


/////////////////////////////////////////////////////////////////////////////
// Destruction
//
CInformViewerDoc::~CInformViewerDoc()
{
}


/////////////////////////////////////////////////////////////////////////////
// Message Map
//
BEGIN_MESSAGE_MAP(CInformViewerDoc, CDocument)
	//{{AFX_MSG_MAP(CInformViewerDoc)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// OnNewDocument()
//
// Insert a warning message so the user knows how long things might take...
//
BOOL CInformViewerDoc::OnNewDocument()
{
	if (!CDocument::OnNewDocument())
		return FALSE;

	m_Text = 
		"! This is just a test application.\n"
		"! More features will be added soon (with luck).\n"
		"! This version is a lot faster than the original -\n"
		"! my next priority is to add editing features.\n";
	return TRUE;
}


//***************************************************************************
// CInformViewerDoc serialization
//***************************************************************************

void CInformViewerDoc::Serialize(CArchive& ar)
{
	if (ar.IsStoring())
	{
	}
	else
	{
	}
}


//***************************************************************************
// CInformViewerDoc diagnostics
//***************************************************************************

#ifdef _DEBUG
void CInformViewerDoc::AssertValid() const
{
	CDocument::AssertValid();
}

void CInformViewerDoc::Dump(CDumpContext& dc) const
{
	CDocument::Dump(dc);
}
#endif //_DEBUG


//***************************************************************************
// CInformViewerDoc commands
//***************************************************************************

/////////////////////////////////////////////////////////////////////////////
// OnOpenDocument()
//
// This is an old-fashioned way of doing things, but it seemed to be faster 
// than streaming...
//
BOOL CInformViewerDoc::OnOpenDocument(LPCTSTR pathName)
{
	FILE * file = fopen(pathName, "rt");
	if ( !file )
		return FALSE;
	if ( fseek(file, 0, SEEK_END) )
	{
		fclose(file);
		return FALSE;
	}
	long maxLength = ftell(file);
	if ( 0 >= maxLength )
	{
		fclose(file);
		return FALSE;
	}
	rewind(file);

	LPSTR pBuffer = m_Text.GetBuffer(maxLength);
	maxLength= fread(pBuffer, sizeof(char), maxLength, file);
	if ( 0 <= maxLength )
		pBuffer[maxLength] = '\0';
	m_Text.ReleaseBuffer();
	m_Text.FreeExtra();

	BOOL ok = ferror(file) == 0;
	fclose(file);
	return ok;
}

