//===========================================================================
// InformViewerView.cpp : implementation of the CInformViewerView class
//===========================================================================

#include "stdafx.h"
#include "InformViewer.h"

#include "InformViewerDoc.h"
#include "InformViewerView.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


//***************************************************************************
// InformViewerView basics
//***************************************************************************

/////////////////////////////////////////////////////////////////////////////
// Construction
//
IMPLEMENT_DYNCREATE(CInformViewerView, CView)

CInformViewerView::CInformViewerView()
{
	// TODO: add construction code here

}


/////////////////////////////////////////////////////////////////////////////
// Destruction
//
CInformViewerView::~CInformViewerView()
{
}


/////////////////////////////////////////////////////////////////////////////
// Message Map
//
BEGIN_MESSAGE_MAP(CInformViewerView, CView)
	//{{AFX_MSG_MAP(CInformViewerView)
	ON_WM_SIZE()
	ON_WM_CREATE()
	ON_WM_SETFOCUS()
	//}}AFX_MSG_MAP
	// Standard printing commands
	ON_COMMAND(ID_FILE_PRINT, CView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_DIRECT, CView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_PREVIEW, CView::OnFilePrintPreview)
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// PreCreateWindow()
//
BOOL CInformViewerView::PreCreateWindow(CREATESTRUCT& cs)
{
	// TODO: Modify the Window class or styles here by modifying
	//  the CREATESTRUCT cs

	return CView::PreCreateWindow(cs);
}


//***************************************************************************
// InformViewerView drawing
//***************************************************************************

void CInformViewerView::OnDraw(CDC* pDC)
{
	CInformViewerDoc* pDoc = GetDocument();
	ASSERT_VALID(pDoc);

	// TODO: add draw code for native data here
}


//***************************************************************************
// CInformViewerView printing
//***************************************************************************

BOOL CInformViewerView::OnPreparePrinting(CPrintInfo* pInfo)
{
	// default preparation
	return DoPreparePrinting(pInfo);
}

void CInformViewerView::OnBeginPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
	// TODO: add extra initialization before printing
}

void CInformViewerView::OnEndPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
	// TODO: add cleanup after printing
}


//***************************************************************************
// CInformViewerView diagnostics
//***************************************************************************

#ifdef _DEBUG
void CInformViewerView::AssertValid() const
{
	CView::AssertValid();
}

void CInformViewerView::Dump(CDumpContext& dc) const
{
	CView::Dump(dc);
}

CInformViewerDoc* CInformViewerView::GetDocument() // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CInformViewerDoc)));
	return (CInformViewerDoc*)m_pDocument;
}
#endif //_DEBUG


//***************************************************************************
// InformViewerView helpers
//***************************************************************************


//***************************************************************************
// CInformViewerView message handlers
//***************************************************************************

/////////////////////////////////////////////////////////////////////////////
// OnCreate()
//
// Set up the edit control.
//
int CInformViewerView::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
	if (CView::OnCreate(lpCreateStruct) == -1)
		return -1;
	
	CRect r;
	GetClientRect(&r);
	m_SourceWnd.Create(WS_CHILD | WS_VISIBLE | ES_MULTILINE | 
		ES_AUTOHSCROLL | ES_AUTOVSCROLL | ES_READONLY | ES_WANTRETURN, 
		r, this, IDC_SOURCEWND);
	if ( !GetDocument()->GetText().IsEmpty() )
	{
		m_SourceWnd.ShowWindow(SW_HIDE);
		m_SourceWnd.SetText(GetDocument()->GetText());
		m_SourceWnd.ShowWindow(SW_SHOW);
	}
	return 0;
}


/////////////////////////////////////////////////////////////////////////////
// OnSetFocus()
//
// Set the focus to the edit control - we don't ewant to do anything with it!
//
void CInformViewerView::OnSetFocus(CWnd* pOldWnd) 
{
	//CView::OnSetFocus(pOldWnd);
	m_SourceWnd.SetFocus();
}


/////////////////////////////////////////////////////////////////////////////
// OnSize()
//
// Resize the edit control to fit the client area.
//
void CInformViewerView::OnSize(UINT nType, int cx, int cy)
{
	CView::OnSize(nType, cx, cy);

	CRect r;
	GetClientRect(&r);
	m_SourceWnd.MoveWindow(&r);
}


/////////////////////////////////////////////////////////////////////////////
// OnUpdate()
//
// Re-style the text in the edit control.
//
void CInformViewerView::OnUpdate(CView* pSender, LPARAM lHint, CObject* pHint)
{
	m_SourceWnd.ShowWindow(SW_HIDE);
	m_SourceWnd.SetText(GetDocument()->GetText());
	m_SourceWnd.ShowWindow(SW_SHOW);
	CView::OnUpdate(pSender, lHint, pHint);
}


