//===========================================================================
// InformViewerView.h : interface of the CInformViewerView class
//
// This simple view class just maintains an InformEditCtrl with it's size 
// equal to the view's client area.  Focus always goes to the control, and 
// update causes the text to be re-styled.
//
// More would have to be done to make something useful out of it (such as an 
// editor).
//===========================================================================

#if !defined(INFORMVIEWERVIEW_H)
#define INFORMVIEWERVIEW_H

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000


//***************************************************************************
// Includes
//***************************************************************************

#include "InformViewerDoc.h"
#include "InformEditCtrl.h"


//***************************************************************************
// Definitions
//***************************************************************************

/////////////////////////////////////////////////////////////////////////////
// CInformViewerView Definition
//
class CInformViewerView : public CView
{
  protected: // create from serialization only
	CInformViewerView();
	DECLARE_DYNCREATE(CInformViewerView)

// Attributes
  public:
	CInformViewerDoc* GetDocument();

// Operations
  public:

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CInformViewerView)
	public:
	virtual void OnDraw(CDC* pDC);  // overridden to draw this view
	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
	protected:
	virtual BOOL OnPreparePrinting(CPrintInfo* pInfo);
	virtual void OnBeginPrinting(CDC* pDC, CPrintInfo* pInfo);
	virtual void OnEndPrinting(CDC* pDC, CPrintInfo* pInfo);
	virtual void OnUpdate(CView* pSender, LPARAM lHint, CObject* pHint);
	//}}AFX_VIRTUAL

// Implementation
  public:
	virtual ~CInformViewerView();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

  protected:
	CInformEditCtrl	m_SourceWnd;

// Generated message map functions
  protected:
	//{{AFX_MSG(CInformViewerView)
	afx_msg void OnSize(UINT nType, int cx, int cy);
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg void OnSetFocus(CWnd* pOldWnd);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

//---------------------------------------------------------------------------

#ifndef _DEBUG  // debug version in InformViewerView.cpp
inline CInformViewerDoc* CInformViewerView::GetDocument()
   { return (CInformViewerDoc*)m_pDocument; }
#endif


//{{AFX_INSERT_LOCATION}}

#endif // !defined(INFORMVIEWERVIEW_H)
