/*=========================================================================*\
|* ConsoleError.c
\*=========================================================================*/

#include "Gal2CC.h"

int errorCount = 0;


/***************************************************************************\
* ClearErrorCount()
*
*/
void ClearErrorCount()
{
	errorCount = 0;
}


/***************************************************************************\
* ErrorCount()
*
*/
int ErrorCount()
{
	return errorCount;
}


/***************************************************************************\
* IncrementErrorCount()
*
*/
void IncrementErrorCount()
{
	errorCount++;
}


/***************************************************************************\
* ReportError()
*
*/
void ReportError(const char * formatString, const char * string)
{
	if ( formatString )
		fprintf(stderr, formatString, string);
	IncrementErrorCount();
}


/***************************************************************************\
* ReportWriteError()
*
*/
void ReportWriteError(FileRecord output, const char * formatString)
{
	if ( NULL == formatString )
		formatString = "Error writing file <%s>!\n";
	fprintf(stderr, formatString, output.name);
	IncrementErrorCount();
}


