/*=========================================================================*\
|* Sector.c
\*=========================================================================*/

#include "Gal2CC.h"


/* For the sector map name */
#define SECTOR_NAME_X		495
#define SECTOR_NAME_Y		0
#define SECTOR_NAME_COLOR	15
#define SECTOR_NAME_FONT	"Arial"
#define SECTOR_NAME_HEIGHT	23
#define SECTOR_NAME_ANGLE	90
#define SECTOR_NAME_JUSTIFY	6
#define SECTOR_NAME_STYLE	16

#define SECTOR_NAME_MAX_LENGTH	64


/* For the sector map subtext */
#define SECTOR_YEAR_X		540
#define SECTOR_YEAR_Y		293
#define SECTOR_YEAR_COLOR	15
#define SECTOR_YEAR_FONT	"Arial"
#define SECTOR_YEAR_HEIGHT	8
#define SECTOR_YEAR_ANGLE	90
#define SECTOR_YEAR_JUSTIFY	2
#define SECTOR_YEAR_STYLE	16

/* For the subsector map name */
#define SUBSECTOR_LOCATION_X 		62.5
#define SUBSECTOR_LOCATION_Y 		-23
#define SUBSECTOR_LOCATION_COLOR	15
#define SUBSECTOR_LOCATION_FONT		"Arial"
#define SUBSECTOR_LOCATION_HEIGHT	3
#define SUBSECTOR_LOCATION_ANGLE 	0
#define SUBSECTOR_LOCATION_JUSTIFY	7
#define SUBSECTOR_LOCATION_STYLE 	16


/***************************************************************************\
* Data
*
*/
static const char * yearText = NULL;

static BOOL subsectorsToOutput[16] =
{
	FALSE, FALSE, FALSE, FALSE, 
	FALSE, FALSE, FALSE, FALSE, 
	FALSE, FALSE, FALSE, FALSE, 
	FALSE, FALSE, FALSE, FALSE
};


/***************************************************************************\
* AddSubsectorOutput()
*
*/
void AddSubsectorOutput(char subsectorLetter)
{
	int index;
	if ( '+' == subsectorLetter || '*' == subsectorLetter )
	{
		for ( index = 0 ; 16 > index ; index++ )
			subsectorsToOutput[index] = TRUE;
	}
	else if ( '-' == subsectorLetter )
	{
		for ( index = 0 ; 16 > index ; index++ )
			subsectorsToOutput[index] = FALSE;
	}
	else
	{
		index = subsectorLetter - ( isupper(subsectorLetter) ? 'A' : 'a' );
		if ( 0 > index || 16 <= index )
			return;
		subsectorsToOutput[index] = TRUE;
	}
}


/***************************************************************************\
* SetYearText()
*
*/
void SetYearText(const char * year)
{
	yearText = year;
}


/***************************************************************************\
* OutputSectorDetails()
*
*/
BOOL OutputSectorDetails(const char * sector, int sectorNameLength, 
						 FileRecord output)
{
	if ( NULL == sector || 0 > sectorNameLength )
		return FALSE;

	BeginLayer(output, "MAP BORDER");

	if ( sectorNameLength )
		OutputText(output, sector, sectorNameLength, 
				   SECTOR_NAME_X, SECTOR_NAME_Y, 
				   SECTOR_NAME_COLOR, SECTOR_NAME_FONT, SECTOR_NAME_HEIGHT, 
				   SECTOR_NAME_ANGLE, SECTOR_NAME_JUSTIFY, SECTOR_NAME_STYLE);

	if ( yearText )
		OutputText(output, yearText, 0, 
				   SECTOR_YEAR_X, SECTOR_YEAR_Y, 
				   SECTOR_YEAR_COLOR, SECTOR_YEAR_FONT, SECTOR_YEAR_HEIGHT, 
				   SECTOR_YEAR_ANGLE, SECTOR_YEAR_JUSTIFY, SECTOR_YEAR_STYLE);

	OutputBaseKey(output, FALSE);
	EndLayer(output);
	return TRUE;
}


/***************************************************************************\
* ConvertSector()
*
*/
BOOL ConvertSector(const char * shortSectorFileName)
{
	int i;
	BOOL result = FALSE;
	char drive[_MAX_DRIVE];
	char dir[_MAX_DIR];
	char fname[_MAX_FNAME];

	char sectorFileName[_MAX_PATH];
	char outputFileName[_MAX_PATH];

	char * sector;
	FileRecord output;

	const char * eol;
	int sectorNameLength;

	/* Build up file names */
	_splitpath(shortSectorFileName, drive, dir, fname, NULL );
	i = strlen(dir);
	if ( 0 == i || ( '/' != dir[i-1] && '\\' != dir[i-1] ) )
		strcat(dir, "/");
	strcat(dir, fname);
	strcat(dir, "/");
	_makepath(sectorFileName, drive, dir, fname, "dat" );
	_makepath(outputFileName, drive, dir, fname, "scr" );

	/* Get the sector file data */
	sector = OpenInputFile(sectorFileName);
	if ( !sector )
		return FALSE;

	/* Output the sector */
	if ( !BeginOutput(outputFileName, &output) )
		goto SectorCleanup;

	OutputHeader(output);
	InitialiseSectorBases(sector);
	ClearSystems();

	for ( i = 0 ; 16 > i ; i++ )
	{
		if ( !ConvertSubsector(sector, drive, dir, output, i, FALSE) )
			IncrementErrorCount();
	}

	CompleteSystems(output, -1, FALSE);

	eol = strchr(sector, '\n');
	sectorNameLength = ( NULL != eol ) ? (int)(eol-sector) : 0;
	result = OutputSectorDetails(sector, sectorNameLength, output);
	EndOutput(output);

	/* Now output any required subsectors */
	strcat(fname, "#");
	if ( SECTOR_NAME_MAX_LENGTH < sectorNameLength )
		sectorNameLength = SECTOR_NAME_MAX_LENGTH;

	for ( i = 0 ; 16 > i ; i++ )
	{
		if ( !subsectorsToOutput[i] )
			continue;

		fname[strlen(fname)-1] = 'A' + i;
		_makepath(outputFileName, drive, dir, fname, "scr" );
		if ( BeginOutput(outputFileName, &output) )
		{

			ClearSystems();
			if ( !ConvertSubsector(sector, drive, dir, output, i, TRUE) )
				IncrementErrorCount();
			CompleteSystems(output, i, TRUE);

			if ( sectorNameLength )
			{
				char buffer[SECTOR_NAME_MAX_LENGTH+30];
				sprintf(buffer, "(subsector %c of %.*s sector)", 'A' + i, 
						sectorNameLength, sector);
				BeginLayer(output, "MAP BORDER");
				OutputText(output, buffer, 0, 
						   SUBSECTOR_LOCATION_X, SUBSECTOR_LOCATION_Y, 
						   SUBSECTOR_LOCATION_COLOR, SUBSECTOR_LOCATION_FONT, 
						   SUBSECTOR_LOCATION_HEIGHT, SUBSECTOR_LOCATION_ANGLE, 
						   SUBSECTOR_LOCATION_JUSTIFY, SUBSECTOR_LOCATION_STYLE);
				EndLayer(output);
			}

			OutputBaseKey(output, TRUE);
			EndOutput(output);
		}
		else
			result = FALSE;
	}

SectorCleanup:
	CloseInputFile(sector);

	return result;
}


