/*=========================================================================*\
|* System.c
\*=========================================================================*/

#include "Gal2CC.h"

#define HEX_NUMBER_V				8.3
#define HEX_NUMBER_H				0
#define HEX_NUMBER_COLOR			15
#define HEX_NUMBER_FONT				"Courier New"
#define HEX_NUMBER_HEIGHT			1.5
#define HEX_NUMBER_ANGLE			0
#define HEX_NUMBER_JUSTIFY			7
#define HEX_NUMBER_STYLE			0

#define WORLD_NAME_V				-4.5
#define WORLD_NAME_H				0
#define WORLD_NAME_NORMAL_COLOR		15
#define WORLD_NAME_CAPITAL_COLOR	2
#define WORLD_NAME_FONT				"Arial"
#define WORLD_NAME_HEIGHT			2.5
#define WORLD_NAME_ANGLE			0
#define WORLD_NAME_JUSTIFY			7
#define WORLD_NAME_STYLE			16

#define WORLD_H						0
#define WORLD_V						0

#define WORLD_DESERT_COLOR			29
#define WORLD_WATER_COLOR			9

#define WORLD_RADIUS				2.5
#define WORLD_LWIDTH				0
#define WORLD_LSTYLE				"Solid"
#define WORLD_FSTYLE				"Solid"

#define WORLD_BELT_SYMBOL_COUNT		8
#define WORLD_BELT_SYMBOL			"Asteroid #"
#define WORLD_BELT_HSCALE			1.0
#define WORLD_BELT_VSCALE			1.0
#define WORLD_BELT_ROTATION			0

#define WORLD_PORT_V				3
#define WORLD_PORT_H				0
#define WORLD_PORT_COLOR			15
#define WORLD_PORT_FONT				"Arial"
#define WORLD_PORT_HEIGHT			2
#define WORLD_PORT_ANGLE			0
#define WORLD_PORT_JUSTIFY			1
#define WORLD_PORT_STYLE			0

#define WORLD_ALLEGIANCE_V			-2.5
#define WORLD_ALLEGIANCE_H			4.5
#define WORLD_ALLEGIANCE_COLOR		15
#define WORLD_ALLEGIANCE_FONT		"Arial"
#define WORLD_ALLEGIANCE_HEIGHT		1.5
#define WORLD_ALLEGIANCE_ANGLE		0
#define WORLD_ALLEGIANCE_JUSTIFY	6
#define WORLD_ALLEGIANCE_STYLE		0

#define WORLD_ZONE_V				0
#define WORLD_ZONE_H				0

#define AMBER_ZONE_RADIUS			6
#define AMBER_ZONE_START			340
#define AMBER_ZONE_FINISH			200
#define AMBER_ZONE_COLOR			10
#define AMBER_ZONE_LWIDTH			0.5
#define AMBER_ZONE_LSTYLE			"Solid"
#define AMBER_ZONE_FSTYLE			"Solid"

#define RED_ZONE_RADIUS				6
#define RED_ZONE_START				340
#define RED_ZONE_FINISH				200
#define RED_ZONE_COLOR				2
#define RED_ZONE_LWIDTH				1
#define RED_ZONE_LSTYLE				"Solid"
#define RED_ZONE_FSTYLE				"Solid"

#define GAS_GIANT_H					3
#define GAS_GIANT_V					3
#define GAS_GIANT_RADIUS			1.0
#define GAS_GIANT_COLOR				15
#define GAS_GIANT_LWIDTH			0
#define GAS_GIANT_LSTYLE			"Solid"
#define GAS_GIANT_FSTYLE			"Solid"


/***************************************************************************\
* Data
*
*/
static BOOL allegiancePrintingMode = TRUE;
static BOOL gasGiantPrintingMode = TRUE;
static BOOL namePrintingMode = TRUE;
static BOOL portPrintingMode = TRUE;
static BOOL zonePrintingMode = TRUE;

static HexNumberPrintingMode hexNumberPrintingMode = OccupiedHexNumberPrinting;

static BOOL systemPresence[SECTOR_HEX_WIDTH][SECTOR_HEX_HEIGHT];


/***************************************************************************\
* Set*Printing()
*
*/
void SetAllegiancePrinting(BOOL mode)	{ allegiancePrintingMode = mode; }
void SetGasGiantPrinting(BOOL mode)		{ gasGiantPrintingMode = mode; }
void SetNamePrinting(BOOL mode)			{ namePrintingMode = mode; }
void SetPortPrinting(BOOL mode)			{ portPrintingMode = mode; }
void SetZonePrinting(BOOL mode)			{ zonePrintingMode = mode; }

void SetHexNumberPrinting(HexNumberPrintingMode mode)
{
	hexNumberPrintingMode = mode;
}


/***************************************************************************\
* ClearSystems()
*
*/
void ClearSystems()
{
	int x, y;
	for ( x = 0 ; SECTOR_HEX_WIDTH > x ; x++ )
		for ( y = 0 ; SECTOR_HEX_HEIGHT > y ; y++ )
			systemPresence[x][y] = FALSE;
}


/***************************************************************************\
* CompleteSystems()
*
*/
void CompleteSystems(FileRecord output, int subsectorIndex, 
					 BOOL subsectorOnly)
{
	IntCoord hex;
	int xSubStart, ySubStart;

	if ( subsectorOnly && ( 0 > subsectorIndex || 16 <= subsectorIndex ) )
		return;
	if ( OccupiedHexNumberPrinting == hexNumberPrintingMode ||
		 NoHexNumberPrinting == hexNumberPrintingMode )
		return;

	if ( subsectorOnly )
	{
		xSubStart = (subsectorIndex % 4) * SUBSECTOR_HEX_WIDTH;
		ySubStart = (subsectorIndex / 4) * SUBSECTOR_HEX_HEIGHT;
	}

	for ( hex.x = 1 ; SECTOR_HEX_WIDTH >= hex.x ; hex.x++ )
	{
		for ( hex.y = 1 ; SECTOR_HEX_HEIGHT >= hex.y ; hex.y++ )
		{
			if ( FullHexNumberPrinting == hexNumberPrintingMode || 
				 !systemPresence[hex.x-1][hex.y-1] )
			{
				char location[5];
				DoubleCoord centre;
				if ( subsectorOnly )
				{
					if ( !IsInSubsector(hex, subsectorIndex) || 
						 !HexNumberToSubsectorCoord(hex, &centre) )
						continue;	/* Probably different subsector */
				}
				else if ( !HexNumberToCoord(hex, &centre, TRUE) )
					continue;	/* Shouldn't happen, but still... */

				sprintf(location, "%02d%02d", hex.x, hex.y);
				OutputText(output, location, 4, 
						   centre.x + HEX_NUMBER_H, centre.y + HEX_NUMBER_V, 
						   HEX_NUMBER_COLOR, HEX_NUMBER_FONT, 
						   HEX_NUMBER_HEIGHT, HEX_NUMBER_ANGLE, 
						   HEX_NUMBER_JUSTIFY, HEX_NUMBER_STYLE);
			}
		}
	}
}


/***************************************************************************\
* OutputSystem()
*
*/
BOOL OutputSystem(const UWPColumnFormat * format, FileRecord output, 
				  const char * uwpLine, int subsectorIndex, 
				  BOOL subsectorOnly)
{
	DoubleCoord centre;
	IntCoord hex;
	const char * str;
	unsigned int lineLength;

	if ( NULL == format || NULL == uwpLine )
		return FALSE;

	if ( 0 > subsectorIndex || 16 <= subsectorIndex )
		return FALSE;

	str = strchr(uwpLine, '\n');
	lineLength = ( NULL == str ) ? strlen(uwpLine) : str - uwpLine;
	if ( ( format->hex + 4 > lineLength ) || ( format->size >= lineLength ) || 
		 ( format->hydrographics >= lineLength ) )
		return FALSE;
	if ( 2 > sscanf(&uwpLine[format->hex], "%2d%2d", &hex.x, &hex.y) )
		return FALSE;
	if ( subsectorOnly )
	{
		if ( !IsInSubsector(hex, subsectorIndex) || 
			 !HexNumberToSubsectorCoord(hex, &centre) )
		return FALSE;	/* Probably different subsector */
	}
	else if ( !HexNumberToCoord(hex, &centre, TRUE) )
		return FALSE;

	systemPresence[hex.x-1][hex.y-1] = TRUE;

	if ( zonePrintingMode && 
		 format->zone < lineLength && ' ' != uwpLine[format->zone] )
	{
		char zone = toupper(uwpLine[format->zone]);
		if ( 'A' == zone )
			OutputArc(output, centre.x + WORLD_ZONE_H, centre.y + WORLD_ZONE_V, 
					  AMBER_ZONE_RADIUS, AMBER_ZONE_START, AMBER_ZONE_FINISH, 
					  AMBER_ZONE_COLOR, AMBER_ZONE_LWIDTH, AMBER_ZONE_LSTYLE, 
					  AMBER_ZONE_FSTYLE);
		else if ( 'R' == zone )
			OutputArc(output, centre.x + WORLD_ZONE_H, centre.y + WORLD_ZONE_V, 
					  RED_ZONE_RADIUS, RED_ZONE_START, RED_ZONE_FINISH, 
					  RED_ZONE_COLOR, RED_ZONE_LWIDTH, RED_ZONE_LSTYLE, 
					  RED_ZONE_FSTYLE);
	}

	if ( OccupiedHexNumberPrinting == hexNumberPrintingMode )
		OutputText(output, &uwpLine[format->hex], 4, 
				   centre.x + HEX_NUMBER_H, centre.y + HEX_NUMBER_V, 
				   HEX_NUMBER_COLOR, HEX_NUMBER_FONT, HEX_NUMBER_HEIGHT, 
				   HEX_NUMBER_ANGLE, HEX_NUMBER_JUSTIFY, HEX_NUMBER_STYLE);

	if ( namePrintingMode && format->name < lineLength )
	{
		str = &uwpLine[min(format->name+format->nameWidth, lineLength)];
		do
		{
			if ( !isspace(*--str) )
			{
				char buffer[256];
				int pop;
				BOOL capital = FALSE;
				int width = min(str - &uwpLine[format->name] + 1, 255);
				strncpy(buffer, &uwpLine[format->name], width);
				buffer[width] = '\0';
				if ( format->populationExponent < lineLength &&
					 1 == sscanf(&uwpLine[format->populationExponent], 
								 "%1x", &pop) && 9 <= pop )
					_strupr(buffer);
				if ( format->notes < lineLength )
				{
					str = strstr(&uwpLine[format->notes], "Cp");
					if ( NULL != str && 
						 ( (unsigned int)(str - &uwpLine[format->notes]) <
						 format->notes + format->notesWidth ) )
						capital = TRUE;
				}

				OutputText(output, buffer, width, 
						   centre.x + WORLD_NAME_H, centre.y + WORLD_NAME_V, 
						   capital ? WORLD_NAME_CAPITAL_COLOR : 
						   WORLD_NAME_NORMAL_COLOR, WORLD_NAME_FONT, 
						   WORLD_NAME_HEIGHT, WORLD_NAME_ANGLE, 
						   WORLD_NAME_JUSTIFY, WORLD_NAME_STYLE);
				break;
			}
		}
		while ( &uwpLine[format->name] < str );
	}

	if ( '0' == uwpLine[format->size] )
	{
		static char beltSymbol[] = WORLD_BELT_SYMBOL;
		beltSymbol[strlen(beltSymbol)-1] = 
			'1' + rand() % WORLD_BELT_SYMBOL_COUNT;
		OutputSymbol(output, beltSymbol, 
					 centre.x + WORLD_H, centre.y + WORLD_V, 
					 WORLD_BELT_HSCALE, WORLD_BELT_VSCALE, 
					 WORLD_BELT_ROTATION);
	}
	else
		OutputCircle(output, centre.x + WORLD_H, centre.y + WORLD_V, 
					 WORLD_RADIUS, ( '0' != uwpLine[format->hydrographics] ) ? 
					 WORLD_WATER_COLOR : WORLD_DESERT_COLOR, 
					 WORLD_LWIDTH, WORLD_LSTYLE, WORLD_FSTYLE);

	if ( portPrintingMode && format->port < lineLength )
		OutputText(output, &uwpLine[format->port], 1, 
				   centre.x + WORLD_PORT_H, centre.y + WORLD_PORT_V, 
				   WORLD_PORT_COLOR, WORLD_PORT_FONT, WORLD_PORT_HEIGHT, 
				   WORLD_PORT_ANGLE, WORLD_PORT_JUSTIFY, WORLD_PORT_STYLE);

	if ( allegiancePrintingMode && format->allegiance+1 < lineLength )
		OutputText(output, &uwpLine[format->allegiance], 2, 
				   centre.x + WORLD_ALLEGIANCE_H, centre.y + WORLD_ALLEGIANCE_V, 
				   WORLD_ALLEGIANCE_COLOR, WORLD_ALLEGIANCE_FONT, 
				   WORLD_ALLEGIANCE_HEIGHT, WORLD_ALLEGIANCE_ANGLE, 
				   WORLD_ALLEGIANCE_JUSTIFY, WORLD_ALLEGIANCE_STYLE);

	if ( gasGiantPrintingMode && 
		 format->gasGiants < lineLength && '0' != uwpLine[format->gasGiants] )
		OutputCircle(output, centre.x + GAS_GIANT_H, centre.y + GAS_GIANT_V, 
					 GAS_GIANT_RADIUS, GAS_GIANT_COLOR, GAS_GIANT_LWIDTH, 
					 GAS_GIANT_LSTYLE, GAS_GIANT_FSTYLE);
	OutputBases(format, output, uwpLine, centre);
	return TRUE;
}

